#define cave_init
///gol_init(chance of living cells(Map Width, Map Height, chance(0-1)))
randomize()

var varMapWidth = argument0,
    varMapHeight = argument1,
    gridMap = ds_grid_create(varMapWidth, varMapHeight),
    varChance = argument2;

for(i=0;i<varMapWidth;i+=1) {
    for(h=0;h<varMapHeight;h+=1) {
        if(random(1)<varChance){
            gridMap[# i, h] = true
        } else {
            gridMap[# i, h] = false
        }  
    }
}

return gridMap;
#define cave_simulate_step
///dungeon_simulate_step(gridId, birthLimit, deathLimit)
var gridMap, varBirthLimit, varDeathLimit, varMapWidth, varMapHeight;

gridMap = argument0
varBirthLimit = argument1
varDeathLimit = argument2

varMapWidth = ds_grid_width(gridMap)
varMapHeight = ds_grid_height(gridMap)

gridMapTemp = ds_grid_create(0,0)

ds_grid_copy(gridMapTemp, gridMap)

for (i=0; i<varMapHeight; i+=1) {
    for (h=0; h<varMapWidth; h+=1) {

        varCellNeighbors = ds_grid_get_sum(gridMap,h-1,i-1,h+1,i+1)

        //When the selected cell live...
        if (gridMap[# h, i]>0) {
            
            varCellNeighbors -= 1
            
            if (varCellNeighbors < varDeathLimit) {
                gridMapTemp[# h, i] = false 
            } else {
                gridMapTemp[# h, i] = true
            }
        } else {
            if (varCellNeighbors > varBirthLimit) {
                gridMapTemp[# h, i] = true
            } else {
                gridMapTemp[# h, i] = false
            }
        }
    }
}

return gridMapTemp
#define cave_generate_map
///dungeon_generate_map(Map Width, Map Height, chance0-1, birth Limit, Death Limit, Steps)
var gridMap, varMapWidth, varMapHeight, varChance, varBirthLimit, varDeathLimit, varSteps;

varMapWidth = argument0
varMapHeight = argument1
gridMap = ds_grid_create(varMapWidth, varMapHeight)
varChance = argument2
varBirthLimit = argument3
varDeathLimit = argument4
varSteps = argument5

ds_grid_copy(gridMap, cave_init(varMapWidth, varMapHeight, varChance))

repeat(varSteps) {
    ds_grid_copy(gridMap,cave_simulate_step(gridMap, varBirthLimit, varDeathLimit))
}

return gridMap;